unit Loading01;

interface

uses
  Windows, Messages, SysUtils, StrUtils, Variants, Classes, Graphics,
  Controls, Dialogs, Menus, Grids, ExtCtrls, StdCtrls,
  UserApp03Data, Service01, ImgLoadSave01, Cargo01,
  AirCraft01, md5, MomentScope01;

// -------------------------------------------------------------------------
type TonWLChange = procedure(Value  : extended) of object;
// -------------------------------------------------------------------------

type TLoading = class(TObject)
private
   // ----------------------------
   //  
   // ----------------------------
   fPanel         : TPanel;          //   
   // ----------------------------
   fImg           : TImage;          //  Image
   fPMenu         : TPopupMenu;      // PopupMenu  fImg
   fSelectorBox   : TListBox;        //   TCargo
   fGrid          : TStringGrid;     //   TCargo
   // ----------------------------
   //  
   // ----------------------------
   fLoadSaveImage : TLoadSaveImage;  //  -  
   fAirCraft      : TAirCraft;       //  - 
   fMomentScope   : TMomentScope;    //  -  
   // ----------------------------
   //    
   // ----------------------------
   fLoadingList   : TList;           //     TCargo
   // ----------------------------
   fSavePenMode   : TPenMode;        //   PenMode
   fContourFlag   : Boolean;         //   
   fContourShow   : Boolean;         //   
   // ---------------------------
   fUniqueCT      : cardinal;        //   
   fCargoInd      : Integer;         //     fList
   // ---------------------------
   fWSumCargo     : extended;        //    
   fonWLChange    : TNotifyEvent;    //    
   // ---------------------------
   fPitchAngle    : extended;        //    
   fRollAngle     : extended;        //    
   fonAngleChange : TNotifyEvent;    //     
   // ---------------------------
   fFileName      : string;          //    
   fMd5Str        : string;
   // ---------------------------
   //    PopupMenu
   procedure CreatePopUpMenu();
   //    PopUpMenu
   procedure ImgMenuClick(Sender: TObject);
   // ---------------------------
   // ,     
   procedure MouseDown(Sender: TObject; Button: TMouseButton;
                       Shift: TShiftState; X, Y: Integer);
   //      
   procedure ReturnRectToLZ(var RqRect : TRect);
   // ,     
   procedure MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
   // ,    
   procedure MouseUp(Sender: TObject; Button: TMouseButton;
                     Shift: TShiftState; X, Y: Integer);
   // ---------------------------
   //   Click  fSelectorBox
   procedure ListBoxClick(Sender: TObject);
   // ---------------------------
   //     Cargo   
   function SetCurrentCargo (RqInd : integer) : boolean;
   // ---------------------------
   //    
   procedure CalcAndShowMoments();
   //         
   procedure CargoVector (XB, YB : extended; var RqCargo : TCargo);
   // ---------------------------
   //      Cargo
   function CreateCargo(RqX, RqY : integer) : TCargo;
   //    
   procedure CalcWSumCargo();
   //      Cargo
   function AddCargoByXY(RqX, RQY : integer; RqTitle : string) : TCargo;
   //      Cargo
   procedure   DeleteCargo(RqInd : integer);
   //      
   procedure ClearLoading();
   // ---------------------------
   //     fGrid
   procedure CargoToGrid();
   // ---------------------------
   //   fMd5Str  
   procedure Md5SaveToFile(RqFileName : string);
   //  md5 -    *.md5
   function ReadMd5FromFile(RqFileName : string) : string;
   // ---------------------------
   //  property
   procedure SetCargoInd(Ind : integer);
   function  GetCargo(Ind : integer) : TCargo;
   function  GetCargoCount() : integer;
   //    
   procedure SetPitchAngle(RqAngle : extended);
   //    
   procedure SetRollAngle(RqAngle  : extended);
public
   // ---------------------------
   constructor Create(RqWinControl : TWinControl;
                      XB, YB, RqWidth, RqHeight : integer);
   procedure   Free();
   //    
   procedure   LoadPicture(RqFileName : string);
   // ---------------------------
   //   
   procedure SaveToFile(RqFileName : string; RqDelimitor : char);
   //       
   function DialogSaveToFile() : string;
   // ---------------------------
   //   
   procedure LoadFromFile(RqFileName : string; RqDelimitor : char);
   //       
   //     (char($09))
   function DialogLoadFromFile() : string;
   // ---------------------------
   //  Image
   property MainImg      : TImage     read fImg;
   // ---------------------------
   //    
   property FileName     : string     read fFileName;
   // ---------------------------
   //  
   property LoadingList  : TList      read fLoadingList;
   //      
   property CargoInd     : Integer    read fCargoInd write SetCargoInd;
   //     
   property CargoCount   : Integer    read GetCargoCount;
   //        
   property Cargo[Ind : integer] : TCargo read GetCargo;
   // ----------------------------
   //    
   property PitchAngle    : extended read fPitchAngle write SetPitchAngle;
   //    
   property RollAngle     : extended read fRollAngle  write SetRollAngle;
   property onAngleChange : TNotifyEvent read  fonAngleChange
                                         write fonAngleChange;
   // ----------------------------
   //      
   property WSumCargo    : extended   read fWSumCargo;
   //  -    
   property onWLChange   : TNotifyEvent read fonWLChange write fonWLChange;
end;

// ----------------------------------------------------------------
//     
const CommentID = '//';

// ================================================================
// ================================================================

implementation

// ================================================================
// ================================================================

// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
// 25.01.2017
//   ,   TControl.
//  CreateControl    class () 
// ,      RqOwner
// (, RqOwner : Form1  Panel1).
function CreateControl(ControlClass  : TControlClass;
                       RqOwner       : TWinControl;
                 const ComponentName : string;
                      X, Y, W, H     : Integer): TControl;
begin
    Result := ControlClass.Create(RqOwner);
    with Result do
    begin
      Parent := RqOwner;               //    
      Name := ComponentName;           //   
      SetBounds(X, Y, W, H);           //   TWinControl
      Visible := True;                 //   
    end;
end;

// ----------------------------------------------------------------
// 25.01.2017
constructor TLoading.Create(RqWinControl : TWinControl;
                           XB, YB, RqWidth, RqHeight : integer);
begin
   inherited Create;
   // ------------------------------------------
   //   
   fPanel := TPanel(CreateControl(TPanel, RqWinControl, '',
                    XB, YB, RqWidth, RqHeight));
   // ------------------------------------------
   //  ListBox -  
   fSelectorBox := TListBox(CreateControl(TListBox, fPanel, '',
                         10, 10, 60, 200));
   fSelectorBox.Clear;
   fSelectorBox.OnClick := ListBoxClick;
   // ------------------------------------------
   //  StringGrid -   
   fGrid := TStringGrid(CreateControl(TStringGrid, fPanel, '',
                         70, 10, 180, 200));
   fGrid.ColCount := 2;
   fGrid.RowCount := 2;
   fGrid.DefaultRowHeight := 16;
   fGrid.DefaultColWidth  := 50;
   fGrid.ScrollBars := ssBoth;
   fGrid.Options  := fGrid.Options + [goEditing,goColSizing];
   fGrid.Cells[0,0] := '';
   fGrid.Cells[1,0] := '';
   // ------------------------------------------
   //   -  
   fLoadSaveImage := TLoadSaveImage.Create(nil, nil);
   // ------------------------------------------
   //  Image -  Image
   fImg  :=  TImage(CreateControl(TImage, fPanel, '',
                    0, 0, fPanel.Width, fPanel.Height));
   fImg.Picture.Bitmap.PixelFormat := pf24bit;
   fImg.Picture.Bitmap.Width  := fImg.Width;
   fImg.Picture.Bitmap.Height := fImg.Height;
   // ------------------------------------------
   //   
   fImg.OnMouseDown := MouseDown;
   fImg.OnMouseMove := MouseMove;
   fImg.OnMouseMove := nil;
   fImg.OnMouseUp   := MouseUp;
   // ------------------------------------------
   //    PopupMenu
    CreatePopUpMenu();
   // ------------------------------------------
   //   - 
   fAirCraft := TAirCraft.Create(AirCraftRec);
   LoadPicture(ApplicationDirectory + fAirCraft.FName);
   fAirCraft.ShowLoadingZone(fImg);
   // ------------------------------------------
   //   -  
   fMomentScope   := TMomentScope.Create(fImg, 252, 10);
   // ------------------------------------------
   //   -  
   fLoadingList := TList.Create;
   fCargoInd    := -1;
   fUniqueCT    := 1;
   // ------------------------------------------
   fPitchAngle  := 0;        //    
   fRollAngle   := 0;        //    
   // ------------------------------------------
end;
// ----------------------------------------------------------------
// 25.01.2017
procedure TLoading.Free();
var Ind : integer;
    wCargo : TCargo;
begin
   fAirCraft.Free;
   fMomentScope.Free;
   //   Cargo 
   if Assigned(fLoadingList)
   then begin
      if fLoadingList.Count > 0
      then begin
         for Ind := 0 to fLoadingList.Count - 1
         do if Assigned(fLoadingList.Items[Ind])
            then begin
              wCargo := TCargo(fLoadingList.Items[Ind]);
              wCargo.Free;
            end;
      end;
      fLoadingList.Free;
   end;
   fPMenu.Free;
   fImg.Free;
   fLoadSaveImage.Free;
   fGrid.Free;
   fSelectorBox.Free;
   fPanel.Free;
   inherited Free();
end;
// ----------------------------------------------------------------
// 21.01.2017
//    PopupMenu
procedure TLoading.CreatePopUpMenu();
var MenuItems : array of TMenuItem;
begin
   // -----------------
   //  PopupMenu
   SetLength(MenuItems, 8);
   MenuItems[0]:= NewItem('  ',
                          TextToShortCut(''),
                          True, True, ImgMenuClick, 0, 'ITEM1');
   MenuItems[0].Tag := 1;
   //-------------------
   MenuItems[1]:= NewItem('  ',
                          TextToShortCut(''),
                          True, True, ImgMenuClick, 0, 'ITEM2');
   MenuItems[1].Tag := 2;
   //-------------------
   MenuItems[2]:= NewItem('  ',
                          TextToShortCut(''),
                          True, True, ImgMenuClick, 0, 'ITEM3');
   MenuItems[2].Tag := 3;
   //-------------------
   MenuItems[3]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, '');
   //-------------------
   MenuItems[4]:= NewItem('   ',
                          TextToShortCut(''),
                          False, True, ImgMenuClick, 0, 'ITEM4');
   MenuItems[4].Tag := 4;
   //-------------------
   MenuItems[5]:= NewItem('   ',
                          TextToShortCut(''),
                          False, True, ImgMenuClick, 0, 'ITEM5');
   MenuItems[5].Tag := 5;
   //-------------------
   MenuItems[6]:= NewItem('-', TextToShortCut(''),
                          False, True, nil, 0, '');
   //-------------------
   MenuItems[7]:= NewItem(' ',
                          TextToShortCut(''),
                          False, True, ImgMenuClick, 0, 'ITEM6');
   MenuItems[7].Tag := 6;
   //-------------------
   //  PopupMenu
   fPMenu := NewPopupMenu(fImg, 'Menu', paLeft, True, MenuItems);
   fImg.PopupMenu := fPMenu;
   // -----------------
   SetLength(MenuItems,0);
end;
// ----------------------------------------------------------------
// 21.01.2017
//    PopUpMenu  fGrid
procedure TLoading.ImgMenuClick(Sender: TObject);
begin
   with TMenuItem(Sender)
   do begin
       case Tag of
       1 : begin  // /  
              Checked := not Checked;
              if Checked
              then fSelectorBox.Visible := True
              else fSelectorBox.Visible := False;
           end;
       2 : begin  // /  
              Checked := not Checked;
              if Checked
              then fGrid.Visible := True
              else fGrid.Visible := False;
           end;
       3 : begin  // /  
              Checked := not Checked;
              if Checked
              then fMomentScope.Visible := True
              else fMomentScope.Visible := False;
           end;
       4 : begin  //    
              if fLoadingList.Count > 0
              then begin
                 if MessageDlg('  '+ #13#10
                             + ' . ?',
                             mtInformation,[mbYes,mbNo],0) = mrYes
                 then DialogLoadFromFile();
              end
              else DialogLoadFromFile();
           end;
       5 : begin  //    
              DialogSaveToFile();
           end;
       6 : begin  //  
                  //
           end;
       else begin end;
       end;
   end;
end;
// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
// 25.01.2017
//    
procedure TLoading.LoadPicture(RqFileName : string);
begin
    if FileExists(RqFileName)
    then begin
       if fLoadSaveImage.LoadImgFromFile(RqFileName, fImg)
       then begin
          if fImg.Picture.Bitmap.PixelFormat <> pf24bit
          then fImg.Picture.Bitmap.PixelFormat := pf24bit;
          fImg.Picture.Bitmap.Width  := fImg.Width;
          fImg.Picture.Bitmap.Height := fImg.Height;
       end;
    end;
end;
// ----------------------------------------------------------------
// 30.01.2017
//    
procedure TLoading.CalcWSumCargo();
var Ind : integer;
begin
    fWSumCargo := 0;
    if fLoadingList.Count < 0
    then Exit;
    for Ind := 0 to fLoadingList.Count - 1
    do fWSumCargo := fWSumCargo + TCargo(fLoadingList[Ind]).WFull;
    //    
    if Assigned(fonWLChange) then fonWLChange(Self);
end;
// ================================================================
//      
// ================================================================
// ----------------------------------------------------------------
//    
procedure TLoading.SetPitchAngle(RqAngle : extended);
const ToPi = Pi/180;
begin
    fPitchAngle := RqAngle * ToPi;
    CalcAndShowMoments();
    if Assigned(fonAngleChange)
    then fonAngleChange(Self);
end;
// ----------------------------------------------------------------
//    
procedure TLoading.SetRollAngle(RqAngle : extended);
const ToPi = Pi/180;
begin
    fRollAngle := RqAngle * ToPi;
    CalcAndShowMoments();
    if Assigned(fonAngleChange)
    then fonAngleChange(Self);
end;
// ----------------------------------------------------------------
//     
function CalcPitchMoment(RqVector : TVector3D;
                          RqAngle : extended;
                          RqWFull : extended) : extended;
var wV : TVector2DP;
begin
    wV.X := RqVector.X;
    wV.Y := RqVector.Z;
    DecartToPolar(wV);
    wV.Ang := wV.Ang + RqAngle;
    PolarToDecart(wV);
    Result := wV.X * RqWFull;
end;
// ----------------------------------------------------------------
//     
function CalcRollMoment(RqVector : TVector3D;
                        RqAngle : extended;
                        RqWFull : extended) : extended;
const ToRad = 180 / Pi;
var wV : TVector2DP;
begin
    wV.X := RqVector.Y;
    wV.Y := RqVector.Z;
    DecartToPolar(wV);
    wV.Ang := wV.Ang + RqAngle;
    PolarToDecart(wV);
    Result := wV.X * RqWFull;
end;
// ----------------------------------------------------------------
//    
procedure TLoading.CalcAndShowMoments();
var wCargo  : TCargo;
    Ind     : integer;
    wMRoll  : extended;   //   
    wMPitch : extended;   //   
begin
    wMRoll  := 0;
    wMPitch := 0;
    if fLoadingList.Count > 0
    then begin
       for Ind := 0 to fLoadingList.Count - 1
       do begin
          wCargo := TCargo(fLoadingList.Items[Ind]);
          with wCargo do
          begin
             wMPitch := wMPitch
                      + CalcPitchMoment(Vector, fPitchAngle, WFull) / 100;
             wMRoll := wMRoll   +
                      + CalcRollMoment(Vector, fRollAngle, WFull)   / 100;
          end;
       end;
    end;
    fMomentScope.MPitch := wMPitch;
    fMomentScope.MRoll  := wMRoll;
end;

// fMRoll    : extended;     //   
// fMPitch   : extended;     //   
// fMTurn    : extended;     //   

// ----------------------------------------------------------------
//         
procedure TLoading.CargoVector (XB, YB : extended;
                                var RqCargo : TCargo);
var V0, V1, V2, V4 : TVector2D;
begin
   //    -     
   V0.X := AirCraftRec.OfsX0;
   V0.Y := AirCraftRec.OfsY0;
   V1.X := XB;
   V1.Y := - YB;
   V2.X :=   RqCargo.XC;
   V2.Y := - RqCargo.YC;
   //    -     
   // V4 = - ( V0 - ( V1 + V2 )) = ( V1 + V2 ) - V0
   V4 := SubVector2D(SumVector2D(V1, V2), V0);
   with RqCargo.Vector
   do begin
      X := V4.X;
      Y := V4.Y;
      Z := AirCraftRec.OfsZ0 + RqCargo.ZC;
(*      //  
      ShowMessage( '  X = ' + Format('%6.2f', [X])
                 + '; Y = ' + Format('%6.2f', [Y])
                 + '; Z = ' + Format('%6.2f', [Z]));
*)
   end;
   //    
   CalcAndShowMoments();
end;

// ----------------------------------------------------------------
// 30.01.2017
//      Cargo
function TLoading.CreateCargo(RqX, RqY : integer) : TCargo;
var wCargo  : TCargo;
    wWLd    : extended;
    wRect   : TRect;
begin
    // ------------------------------------
    //  
    Result := nil;
    if not Assigned(fAirCraft) then Exit;
    // ------------------------------------
    //   - 
    // ------------------------------------
    //  Rect   Image
    wRect := fAirCraft.XYLenToRect(RqX, RqY, CargoRec.LenX, CargoRec.LenY);
    //      
    if not IsRectInMainRect(fAirCraft.RectLZ, wRect)
    then begin
       MessageDlg('  ',
                   mtWarning, [mbOk], 0);
       Exit;
    end;
    // ------------------------------------
    //      
    wWLd := CargoRec.Weight + CargoWeight;    // UserApp01Data
    if  fWSumCargo + wWLd > fAirCraft.Weight
    then begin
       MessageDlg('  ,  '
       + #13#10 + ' .   ...',
       mtError, [mbOk], 0);
       Exit;
    end;
    // ------------------------------------
    //    
    wCargo := TCargo.Create(fImg);
    with wCargo
    do begin
       Cutout := wRect;
       // ------------------------------------
       //    
       Indx := fUniqueCT;
       Id := CargoRec.Id;
       XB := fAirCraft.XOfsetRect(wRect);
       YB := fAirCraft.YOfsetRect(wRect);
       XC := CargoRec.LenX / 2;
       YC := CargoRec.LenY / 2;
       ZC := CargoZC;  // UserApp01Data
       WFull := wWLd;
       CargoVector(XB, YB, wCargo);
    end;
    Result := wCargo;
end;

// ----------------------------------------------------------------
// 25.01.2017
//      Cargo
function TLoading.AddCargoByXY(RqX, RqY : integer; RqTitle : string) : TCargo;
var Ind : integer;
begin
    Result := CreateCargo(RqX, RqY);
    if Assigned(Result)
    then begin
       // -------------------------------
       //     
       Ind := fLoadingList.Add(Result);
       Result.Visible := True;
       SetCurrentCargo(Ind);
       // --------------------------------
       //    
       fSelectorBox.Items.Add('  ' + IntToStr(fUniqueCT));
       fSelectorBox.ItemIndex := fCargoInd;
       // --------------------------------
       //    
       CalcWSumCargo();
       // --------------------------------
       Inc(fUniqueCT);
    end;
end;

// ----------------------------------------------------------------
// 25.01.2017
//      Cargo
procedure  TLoading.DeleteCargo(RqInd : integer);
var wCargo : TCargo;
begin
  if (RqInd < 0) or (RqInd > fLoadingList.Count - 1) then Exit;
  wCargo := TCargo(fLoadingList.Items[RqInd]);
  fLoadingList.Delete(RqInd);
  // ---------------------------------
  //  
  if Assigned(wCargo)
  then begin
      if wCargo.Visible then wCargo.Visible := False;
      wCargo.Free;
  end;
  //    
  CalcWSumCargo();
  //    
  CalcAndShowMoments();
  // ---------------------------------
  if fLoadingList.Count > 0
  then begin
     fCargoInd := fLoadingList.Count - 1;
     //  Grid  Cargo
     CargoToGrid();
  end
  else begin
     //    
     fCargoInd := -1;
     fUniqueCT :=  1;
     fGrid.RowCount := 2;
     fGrid.Cells[1,1] :='';
  end;
  // ---------------------------------
  fSelectorBox.Items.Delete(RqInd);
end;

// ----------------------------------------------------------------
// 01.02.2017
//      
procedure TLoading.ClearLoading();
var Ind : integer;
begin
   if fLoadingList.Count <= 0 then Exit;
   for Ind := fLoadingList.Count downto 0
   do DeleteCargo(Ind);
end;

// ----------------------------------------------------------------
// 25.01.2017
//     Cargo   
function TLoading.SetCurrentCargo (RqInd : integer) : boolean;
var wCargo : TCargo;
begin
  Result := False;
  with fImg.Canvas
  do begin
     //   
     if (fCargoInd >= 0) and (fCargoInd < fLoadingList.Count)
     then begin
        wCargo := TCargo(fLoadingList.Items[fCargoInd]);
        Pen.Color := clBlack;
        Brush.Style := bsClear;
        Rectangle(wCargo.Cutout);
     end;
     //   
     if (RqInd >= 0) and (RqInd < fLoadingList.Count)
     then begin
        fCargoInd := RqInd;
        wCargo := TCargo(fLoadingList.Items[fCargoInd]);
        Pen.Color := clRed;
        Brush.Style := bsClear;
        Rectangle(wCargo.Cutout);
        Result := True;
        // --------------------------------------------
        fSelectorBox.ItemIndex := fCargoInd;
        //  Grid  Cargo
        CargoToGrid();
        // --------------------------------------------
        CargoVector(wCargo.XB, wCargo.YB, wCargo);
     end;
   end;
end;

// ----------------------------------------------------------------
// 30.01.2017
// ,     
procedure TLoading.MouseDown(Sender: TObject; Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
var wCargo : TCargo;
    Ind    : integer;
begin
   // ------------------------------
   //  
   if (Shift * [ssShift] =  []) and
      (Shift * [ssAlt]   =  []) and
      (Shift * [ssCtrl]  =  [])
   then begin
      fImg.OnMouseUp   := nil;
      fImg.OnMouseMove := nil;
      for Ind := 0 to fLoadingList.Count - 1 do
      begin
        wCargo := TCargo(fLoadingList.Items[Ind]);
        if IsXYInRect(wCargo.Cutout, X, Y)
        then begin
           SetCurrentCargo(Ind);
           Break;
        end;
      end;
      Exit;
   end;
   // ------------------------------
   //  (ssShift)  
   if (Shift * [ssShift] <> []) and
      (Shift * [ssAlt]   =  []) and
      (Shift * [ssCtrl]  =  [])
   then begin
       fImg.OnMouseUp   := nil;
       fImg.OnMouseMove := nil;
       AddCargoByXY(X,Y,'Cargo');
       Exit;
   end;
   // ------------------------------
   //  (ssCtrl) 
   if (Shift * [ssShift] =  []) and
      (Shift * [ssAlt]   =  []) and
      (Shift * [ssCtrl]  <> [])
   then begin
       fImg.OnMouseUp   := nil;
       fImg.OnMouseMove := nil;
       if (fCargoInd < 0) or (fLoadingList.Count <  1) then Exit;
       DeleteCargo(fCargoInd);
       fCargoInd := -1;
       Exit;
   end;
   // ------------------------------
   //  (ssAlt) 
   if (Shift * [ssShift] =  []) and
      (Shift * [ssAlt]   <> []) and
      (Shift * [ssCtrl]  =  [])
   then begin
      //   TCargo
      if (fCargoInd < 0) or (fLoadingList.Count <  1) then Exit;
      wCargo := TCargo(fLoadingList.Items[fCargoInd]);
      if not Assigned(wCargo) then Exit;
      //    Image
      wCargo.Visible := False;
      //  wCargo.Rect    X,Y
      wCargo.Cutout := MoveRectangle(wCargo.Cutout, X,Y);
      //     
      with fImg.Canvas do
      begin
        fSavePenMode := Pen.Mode;      //   
        Pen.Mode    := pmNotXor;       //   NotXor
        Brush.Style := bsClear;        //   
      end;
      fContourFlag := True;
      fContourShow := False;
      //   MouseMove
      fImg.OnMouseMove := MouseMove;
      fImg.OnMouseUp   := MouseUp;
   end;
end;
// ----------------------------------------------------------------
// 30.01.2017
//      
procedure TLoading.ReturnRectToLZ(var RqRect : TRect);
var wPix : integer;
begin
   if not Assigned(fAirCraft) then Exit;
   if IsRectInMainRect(fAirCraft.RectLZ, RqRect) then Exit;
   with fAirCraft do
   begin
      // ---------------------------
      //  RqRect   RectLZ.Left  RectLZ.Right
      if RqRect.Left <  RectLZ.Left
      then RqRect := MoveRectangle (RqRect, RectLZ.Left, RqRect.Top);
      if RqRect.Right >  RectLZ.Right
      then begin
         wPix := RqRect.Right - RqRect.Left;
         RqRect := MoveRectangle (RqRect, RectLZ.Right - wPix , RqRect.Top);
      end;
      // ---------------------------
      //  RqRect   RectLZ.Top  RectLZ.Bottom
      if RqRect.Top <  RectLZ.Top
      then RqRect := MoveRectangle (RqRect, RqRect.Left, RectLZ.Top);
      if RqRect.Bottom > RectLZ.Bottom
      then begin
          wPix := RqRect.Bottom - RqRect.Top;
          RqRect := MoveRectangle (RqRect, RqRect.Left, RectLZ.Bottom - wPix);
      end;
   end;
end;

// ----------------------------------------------------------------
// 30.01.2017
// ,     
procedure TLoading.MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var wCargo : TCargo;
    wRect  : TRect;
//    XB, YB : extended;
begin
   if fContourFlag = False then Exit;
   wCargo := TCargo(fLoadingList.Items[fCargoInd]);
   with fImg.Canvas do
   begin
        if fContourShow
        then begin
           //     
           Rectangle(wCargo.Cutout);
        end;
        //  Rect   X,Y
        wRect := MoveRectangle(wCargo.Cutout, X,Y);
        //      
        ReturnRectToLZ (wRect);
        wCargo.Cutout := wRect;
        //     
        Rectangle(wCargo.Cutout);
        //   
        fContourShow := True;
        // --------------------------------------------
(*
        //   
        XB := fAirCraft.XOfsetRect(wRect);
        YB := fAirCraft.YOfsetRect(wRect);
        CargoVector(XB, YB, wCargo);
*)
   end;
end;
// ----------------------------------------------------------------
// 30.01.2017
// ,    
procedure TLoading.MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var wCargo : TCargo;
begin
   //   MouseMove
   fImg.OnMouseMove := nil;
   if not fContourFlag then Exit;
   //   TCargo
   if (fCargoInd < 0) or (fLoadingList.Count <  1) then Exit;
   wCargo := TCargo(fLoadingList.Items[fCargoInd]);
   if not Assigned(wCargo) then Exit;
   //   
   fContourFlag := False;
   with fImg.Canvas do
   begin
        if fContourShow
        then begin
           //     
           Rectangle(wCargo.Cutout);
        end;
        //  
        Pen.Mode := fSavePenMode;
   end;
   with wCargo do
   begin
        //   
        XB := fAirCraft.XOfsetRect(Cutout);
        YB := fAirCraft.YOfsetRect(Cutout);
        CargoVector(XB, YB, wCargo);
        //   
        Visible := True;
   end;
   CargoToGrid();
end;
// ----------------------------------------------------------------
// 30.01.2017
//   Click  fSelectorBox
procedure TLoading.ListBoxClick(Sender: TObject);
var Ind : integer;
begin
   Ind := fSelectorBox.ItemIndex;
   if (Ind >= 0) and (Ind < fLoadingList.Count)
   then SetCurrentCargo(Ind);
end;
// =========================================================================
//  PROPERTYES
// =========================================================================
// ----------------------------------------------------------------
//   property CargoInd
procedure TLoading.SetCargoInd(Ind : integer);
begin
   if fLoadingList.Count < 1
   then begin
      fCargoInd := -1;
      Exit;
   end;
   if (Ind >= 0) and (Ind <= fLoadingList.Count - 1)
   then fCargoInd := Ind;
end;
// ----------------------------------------------------------------
//   property CargoOBJ
function TLoading.GetCargo(Ind : integer) : TCargo;
begin
   Result := nil;
   if fLoadingList.Count < 1 then Exit;
   if (Ind >= 0) and (Ind <= fLoadingList.Count - 1)
   then Result := TCargo(fLoadingList.Items[fCargoInd]);
end;
// ----------------------------------------------------------------
//   property CargoCount
function TLoading.GetCargoCount() : integer;
begin
   Result := fLoadingList.Count;
end;

// =========================================================================
//  
// =========================================================================
// -------------------------------------------------------------------------
//     fGrid
procedure TLoading.CargoToGrid();
begin
   if fCargoInd < 0 then Exit;
   if not Assigned(fLoadingList.Items[fCargoInd]) then Exit;
   with TCargo(fLoadingList.Items[fCargoInd]) do
   begin
      fGrid.RowCount := 8;
      //  1
      fGrid.Cells[0,1] := 'Id';
      fGrid.Cells[1,1] := Id;
      //  2
      fGrid.Cells[0,2] := 'XB (.)';
      fGrid.Cells[1,2] := Format('%6.2f', [XB]);
      //  3
      fGrid.Cells[0,3] := 'YB (.)';
      fGrid.Cells[1,3] := Format('%6.2f', [YB]);
      //  4
      fGrid.Cells[0,4] := 'XC (.)';
      fGrid.Cells[1,4] := Format('%6.2f', [XC]);
      //  5
      fGrid.Cells[0,5] := 'YC (.)';
      fGrid.Cells[1,5] := Format('%6.2f', [YC]);
      //  6
      fGrid.Cells[0,6] := 'ZC (.)';
      fGrid.Cells[1,6] := Format('%6.2f', [ZC]);
      //  7
      fGrid.Cells[0,7] := ' (.)';
      fGrid.Cells[1,7] := Format('%6.2f', [WFull]);
   end;
end;

// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
// 01.02.2017
procedure TLoading.Md5SaveToFile(RqFileName : string);
var wStream : TMemoryStream;
    wPBuff  : pointer;
begin
  //  
  if (RqFileName = '') or (Length(fMd5Str) <> 32) then Exit;
  //    
  wPBuff := Addr(fMd5Str[1]);
  wStream := TMemoryStream.Create();
  try
    wStream.Write(wPBuff^,Length(fMd5Str));
    wStream.SaveToFile(RqFileName + '.md5');
  finally
    wStream.Free;
  end;
end;

// ----------------------------------------------------------------
// 01.02.2017
//   
procedure TLoading.SaveToFile(RqFileName : string; RqDelimitor : char);
var wList      : TStringList;
    wCargo     : TCargo;
    wMD5Digest : TMD5Digest;
    Ind        : integer;
    wStr       : string;
begin
  if fLoadingList.Count < 1 then Exit;
  try
      wList := TStringList.Create;
      wList.Add(CommentID + '  .   : ' + DateToStr(Now()));
      wList.Add(CommentID + '  : ' + RqFileName);
      for Ind := 0 to fLoadingList.Count - 1 do
      begin
          wStr := '';
          wCargo := TCargo(fLoadingList.Items[Ind]);
          // ------------------------------
          //    
          // ------------------------------
          //   fGrid 
          with wCargo
          do begin
             wStr := wStr + Format('%3d',   [Indx])  + RqDelimitor;
             wStr := wStr + Format('%20s',  [Id])    + RqDelimitor;
             wStr := wStr + Format('%6.2f', [XB])    + RqDelimitor;
             wStr := wStr + Format('%6.2f', [YB])    + RqDelimitor;
             wStr := wStr + Format('%6.2f', [XC])    + RqDelimitor;
             wStr := wStr + Format('%6.2f', [YC])    + RqDelimitor;
             wStr := wStr + Format('%6.2f', [ZC])    + RqDelimitor;
             wStr := wStr + Format('%6.2f', [WFull]) + RqDelimitor;
             //   fGrid 
             wStr := wStr + Format('%4d', [Cutout.Left])   + RqDelimitor;
             wStr := wStr + Format('%4d', [Cutout.Top])    + RqDelimitor;
             wStr := wStr + Format('%4d', [Cutout.Right])  + RqDelimitor;
             wStr := wStr + Format('%4d', [Cutout.Bottom]) + RqDelimitor;
          end;
          // ------------------------------
          //  
          wList.Add(wStr);
      end;
      //    
      wList.SaveToFile(RqFileName);
      fFileName  := RqFileName;
      wList.Free;
      // ----------------------------
      //  MD5
      wMD5Digest := MD5File(fFileName);
      fMd5Str := MD5DigestToStr(wMD5Digest);
      // ----------------------------
      //  Md5   
      Md5SaveToFile(fFileName);
  except
       MessageDlg('   : '
       +   #13#10 + RqFileName,
          mtError, [mbOk], 0);
   end;
end;
// -----------------------------------------------------------------
// 01.02.2017
//       
function TLoading.DialogSaveToFile() : string;
var wExt    : string;
    wDialog : TSaveDialog;
    wFileExt : string;     //   
begin
  Result := '';
  wExt   := '.txt';
  wDialog := TSaveDialog.Create(nil);
  //  
  wDialog.Filter := 'CargoList files (*'
                    + LowerCase(wExt) + ')|*' + UpperCase(wExt);
  //   
  if wDialog.Execute
  then begin
     Result := wDialog.FileName;
     wFileExt  := UpperCase(ExtractFileExt(Result));
     //     ,    
     if not (wFileExt = UpperCase(wExt))
     then Result := Result + LowerCase(wExt);
     //   
     if FileExists(Result)
     then begin
        if MessageDlg('   .'+ #13#10
                    + '   ?',
                       mtInformation,[mbYes,mbNo],0) = mrYes
        then SaveToFile(Result,  char($09));
     end
     else SaveToFile(Result,  char($09));
  end;
  wDialog.Free;
end;

// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
// 01.02.2017
//  md5 -    *.md5
function TLoading.ReadMd5FromFile(RqFileName : string) : string;
var wStream : TMemoryStream;
    wChar   : char;
    Ind     : integer;
begin
  //  
  Result := '';
  //   
   if not FileExists(RqFileName + '.md5')
   then begin
       MessageDlg('MD5  -   : ' +   #13#10
                 + RqFileName + '.md5' +   #13#10
                 + ' !    ...',
                 mtWarning, [mbOk], 0);
       Exit;
   end;
  //  MemoryStream
  wStream := TMemoryStream.Create();
  try
    //    TMemoryStream
    wStream.LoadFromFile(RqFileName + '.md5');
    if wStream.Size > 0
    then begin
       //    
       for Ind := 0 to (wStream.Size - 1)
       do begin
         wStream.Read(wChar,1);
         Result := Result + wChar;
       end;
       // ShowMessage(Result);  //  
    end;
  finally
     wStream.Free;
  end;
end;

// ----------------------------------------------------------------
// 01.02.2017
//  " "    
function DetectComment(RqStr : string) : boolean;
var   wStr : string;
begin
   Result := False;
   wStr := Trim(RqStr);
   if Length(wStr) >= 2
   then begin
      if LeftStr(RqStr, 2) = CommentID then Result := True;
   end;
end;
// ----------------------------------------------------------------
// 01.02.2017
//      
function GetSubStr(RqDelimiter : string; var RqStr : string) : string;
var   wPos, wCount : integer;
begin
   Result := '';
   RqStr := Trim(RqStr);
   wPos := PosEx(RqDelimiter,RqStr);
   if wPos > 0
   then begin
      wCount := wPos - 1;
      Result :=  Copy(RqStr, 1, wCount);
      Delete(RqStr, 1, wPos);
   end
   else begin
      Result := RqStr;
      RqStr  := '';
   end;
end;
// ----------------------------------------------------------------
// 01.02.2017
//   
procedure TLoading.LoadFromFile(RqFileName : string; RqDelimitor : char);
var wList        : TStringList;
    wCargo       : TCargo;
    wMD5Digest   : TMD5Digest;
    wMd5Str      : string;
    Ind1, Ind2   : integer;
    wStr         : string;
    wSubStr      : string;
    wInt         : integer;
    wExt         : extended;
    wRect        : TRect;
    wErrCount    : integer;
begin
   //   
   if not FileExists(RqFileName)
   then begin
       MessageDlg('   : ' +   #13#10
                 + RqFileName +   #13#10
                 + ' !    ...',
                 mtWarning, [mbOk], 0);
       Exit;
   end;
   if not Assigned(fAirCraft) then Exit;
   // -------------------------------------
   //    
   wErrCount := 0;
   wList := TStringList.Create;
   try
      wList.LoadFromFile(RqFileName);
   except
      MessageDlg('   : '
      +   #13#10 + RqFileName
      +   #13#10 + '   ...',
          mtError, [mbOk], 0);
      fFileName := '';
      wErrCount := 1;
   end;
   if  wErrCount > 0 then Exit;
   // -------------------------------------
   //    
   // -------------------------------------
   fFileName := RqFileName;
   // -------------------------------------
   //      
   ClearLoading();
   // -------------------------------------
   //   
   if wList.Count > 0
   then begin
      for Ind1 := wList.Count -1 downto 0
      do if DetectComment(wList.Strings[Ind1])
         then wList.Delete(Ind1);
   end;
   // -------------------------------------
   //     
   if wList.Count > 0
   then begin
         fUniqueCT := 1;
         for Ind1 := 0 to wList.Count -1 do
         begin
             //    
             wCargo := TCargo.Create(fImg);
             //   
             wErrCount := 0;
             wStr := wList.Strings[Ind1];
             // ---------------------------
             //   fGrid 
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToInt(wSubStr, wInt)
             then wCargo.Indx := wInt
             else Inc(wErrCount);
             // ---------------------------
             wCargo.Id := GetSubStr(RqDelimitor, wStr);
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToFloat(wSubStr, wExt)
             then wCargo.XB := wExt
             else Inc(wErrCount);
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToFloat(wSubStr, wExt)
             then wCargo.YB := wExt
             else Inc(wErrCount);
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToFloat(wSubStr, wExt)
             then wCargo.XC := wExt
             else Inc(wErrCount);
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToFloat(wSubStr, wExt)
             then wCargo.YC := wExt
             else Inc(wErrCount);
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToFloat(wSubStr, wExt)
             then wCargo.ZC := wExt
             else Inc(wErrCount);
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToFloat(wSubStr, wExt)
             then wCargo.WFull := wExt
             else Inc(wErrCount);
             // ---------------------------
             //   fGrid 
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToInt(wSubStr, wInt)
             then wRect.Left := wInt                  
             else Inc(wErrCount);
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToInt(wSubStr, wInt)
             then wRect.Top := wInt
             else Inc(wErrCount);
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToInt(wSubStr, wInt)
             then wRect.Right := wInt
             else Inc(wErrCount);
             // ---------------------------
             wSubStr := GetSubStr(RqDelimitor, wStr);
             if TryStrToInt(wSubStr, wInt)
             then wRect.Bottom := wInt
             else Inc(wErrCount);
             // ---------------------------
             wCargo.Cutout := wRect;
             // ---------------------------
             if not (wErrCount > 0)
             then begin
                 // -------------------------------
                 //     
                 Ind2 := fLoadingList.Add(wCargo);
                 wCargo.Visible := True;
                 SetCurrentCargo(Ind2);
                 // --------------------------------
                 //    
                 fSelectorBox.Items.Add('  ' + IntToStr(wCargo.Indx));
                 fSelectorBox.ItemIndex := fCargoInd;
                 // --------------------------------
                 Inc(fUniqueCT);
             end
             else begin
                 MessageDlg('    : '
                 +  #13#10 + wCargo.Id
                 +  #13#10 + '    ...',
                    mtError, [mbOk], 0);
                 wCargo.Free;
                 // -------------
                 fFileName := '';
                 Break;
             end;
             // ---------------------------
         end; // of for
         // --------------------------------
         //    
         CalcWSumCargo();
         // --------------------------------
         //    -
         if not (wErrCount > 0)
         then begin
            //  MD5  
            wMD5Digest := MD5File(fFileName);
            fMd5Str := MD5DigestToStr(wMD5Digest);
            //     Md5
            wMd5Str := ReadMd5FromFile(fFileName);
            if fMd5Str <> wMd5Str
            then begin
               MessageDlg(' ()   () MD5 :'
                 +  #13#10 + ' = ' + fMd5Str
                 +  #13#10 + ' = ' + wMd5Str,
                    mtError, [mbOk], 0);
            end;
         end;
   end; // of if wList.Count > 0
end;

// -----------------------------------------------------------------
// 01.02.2017
//       
//     (char($09))
function TLoading.DialogLoadFromFile() : string;
var  wExt    : string;
     wDialog : TOpenDialog;
begin
  Result := '';
  wExt := '.txt';
  wDialog := TOpenDialog.Create(nil);
  //  
  wDialog.Filter := 'CargoList files (*'
                    + LowerCase(wExt) + ')|*' + UpperCase(wExt);
  //   
  if wDialog.Execute
  then begin
     Result := wDialog.FileName;
     LoadFromFile(Result, char($09));
  end;
  wDialog.Free;
end;


// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

end.
